import javax.swing.*;
import java.awt.*;
import java.awt.event.*;


/** This class is used to demo the use of button listeners.
    An instance has two buttons, exactly one of which is always
    enabled. Click the enabled one and the other one becomes
    enabled. */
public class ButtonDemo1 extends JFrame 
                        implements ActionListener {
    /** Class invariant: exactly one of eastButton and westButton is enabled */
    private JButton westButton= new JButton("west");
    private JButton eastButton= new JButton("east");

    /** Constructor: an invisible frame with title t and two buttons */
	public ButtonDemo1(String t) {
		super(t);
		
		Container cp= getContentPane();
		cp.add(westButton,BorderLayout.WEST);
		cp.add(eastButton,BorderLayout.EAST);
	          
		westButton.setEnabled(false);
		eastButton.setEnabled(true);
	
		westButton.addActionListener(this);
		eastButton.addActionListener(this);
		
		pack();
	}
	       
	/** Process a click of a button */
	public void actionPerformed(ActionEvent e) {
		boolean b= eastButton.isEnabled();
		eastButton.setEnabled(!b);
		westButton.setEnabled(b);
	}
	
	public static void main(String[] args) {
		ButtonDemo1 bd= new ButtonDemo1("demo buttons");
		bd.setVisible(true);
	}
}